#include "CreateEntityCommand.h"

#include "../DataTypes/DataRobot.h"
#include "../DataTypes/DataBall.h"
#include "../DataTypes/DataField.h"
#include "../DataTypes/DataString.h"
#include "SimRobot.h"
#include "SimField.h"
#include "SimBall.h"
class ISimEntity;
namespace SimulationEngine
{

CreateEntityCommand::CreateEntityCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandCreateEntityKey())
{
}

CreateEntityCommand::~CreateEntityCommand()
{
}

list<DataParameter*> CreateEntityCommand::execute(list <DataParameter *> pars)
{
	DataEntity *dataentity = (DataEntity *)(pars.front());
	ISimEntity *entity;
	list<DataParameter *> ret; //empty list
	if (DataRobot *datarobot = dynamic_cast<DataRobot *>(dataentity))
	{
		entity = new SimRobot(*datarobot);
		ret.push_back(new DataString("Robot successfully created"));
		
	}	
	else if (DataBall *databall = dynamic_cast<DataBall *>(dataentity))
	{
		entity = new SimBall(*databall);
		ret.push_back(new DataString("Ball successfully created"));
	}
	else if (DataField *datafield = dynamic_cast<DataField *>(dataentity))
	{
		entity = new SimField(*datafield);
		ret.push_back(new DataString("Field successfully created"));
	}

	EntityManager *entitymanager = EntityManager::GetInstance();
	entitymanager->AddEntity(entity);


	return ret;
}

}

#include "ISimEntity.h"
